#ifndef __CPNGImage__
#define __CPNGImage__

#include "CBaseImage.hpp"
using Exponent::GUI::Graphics::CBaseImage;

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CPNGImage CPNGImage.hpp
			 * @brief Representation of a PNGImage
			 *
			 * @date 3/3/2007
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * 
			 * @note All contents of this source code are copyright 2007 Exp Digital Uk.
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.
			 * Certain sections of this code may come from other sources. They are credited where applicable.
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk			 * 
			 *
			 * $Id: CPNGImage.hpp,v 1.1 2007/03/03 02:59:20 paul Exp $
			 */
			class CPNGImage : public CBaseImage
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction with a file name
				 * @param filename Name of the file to load
				 * @throws CException On load error
				 */
				CPNGImage(const CSystemString &filename);

				/**
				 * Construction
				 */
				CPNGImage();

				/**
				 * Destruction
				 */
				virtual ~CPNGImage();

//	===========================================================================

				/**
				 * Get the format
				 * @retval EImageFormats The format of the image
				 */
				virtual EImageFormats getImageFormat() const { return e_png; }

				/**
				 * Load from a file
				 * @param filename The name of the file
				 * @retval bool True if loaded the image properly, false on error
				 */
				virtual bool loadFromFile(const CSystemString &filename);

//	===========================================================================

				/**
				 * Get a new JPG image instance
				 * @param path The containing folder of the image
				 * @param filename the name of the file
				 * @retval CJPEGImage* The new instance or NULL on error
				 */
				static CPNGImage *getNewInstance(const CSystemString &path, const CString &filename);

			};
		}
	}
}
#endif		// End of CPNGImage.hpp